/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RowedStorageBlockEntity
extends BasicLootBlockEntity {
    protected final int rows;

    protected RowedStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int rows) {
        super(type, pos, state, rows * 9);
        this.rows = rows;
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        ChestMenu chestMenu;
        return menu instanceof ChestMenu && (chestMenu = (ChestMenu)menu).getContainer() == this;
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return new ChestMenu(this.getChestMenu(this.rows), windowId, playerInventory, (Container)this, this.rows);
    }

    public MenuType<ChestMenu> getChestMenu(int rows) {
        return switch (rows) {
            case 1 -> MenuType.GENERIC_9x1;
            case 2 -> MenuType.GENERIC_9x2;
            case 3 -> MenuType.GENERIC_9x3;
            case 4 -> MenuType.GENERIC_9x4;
            case 5 -> MenuType.GENERIC_9x5;
            case 6 -> MenuType.GENERIC_9x6;
            default -> throw new IllegalArgumentException("Rows can only be a minimum of one and a maximum of six");
        };
    }
}

