/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageCarGui
implements Message<MessageCarGui> {
    public static final CustomPacketPayload.Type<MessageCarGui> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"car_gui"));
    private UUID uuid;

    public MessageCarGui() {
    }

    public MessageCarGui(Player player) {
        this.uuid = player.getUUID();
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        if (!sender.getUUID().equals(this.uuid)) {
            Main.LOGGER.error("The UUID of the sender was not equal to the packet UUID");
            return;
        }
        Entity entity = sender.getVehicle();
        if (entity instanceof EntityCarBase) {
            EntityCarBase car = (EntityCarBase)entity;
            car.openCarGUI((Player)sender);
        }
    }

    @Override
    public MessageCarGui fromBytes(RegistryFriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }

    @Override
    public CustomPacketPayload.Type<MessageCarGui> type() {
        return TYPE;
    }
}

