/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.PredicateUUID;
import de.maxhenkel.car.entity.car.base.EntityCarLockBase;
import de.maxhenkel.car.items.ModItems;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ItemKey
extends Item {
    public ItemKey() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        UUID carUUID = ItemKey.getCar(stack);
        if (carUUID == null) {
            if (worldIn.isClientSide) {
                playerIn.displayClientMessage((Component)Component.translatable((String)"message.key_no_car"), true);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (worldIn.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        List cars = worldIn.getEntitiesOfClass(EntityCarLockBase.class, new AABB(playerIn.getX() - 25.0, playerIn.getY() - 25.0, playerIn.getZ() - 25.0, playerIn.getX() + 25.0, playerIn.getY() + 25.0, playerIn.getZ() + 25.0), (Predicate)((Object)new PredicateUUID(carUUID)));
        if (cars.isEmpty()) {
            playerIn.displayClientMessage((Component)Component.translatable((String)"message.car_out_of_range"), true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        EntityCarLockBase car = (EntityCarLockBase)((Object)cars.get(0));
        if (car.getPassengers().stream().anyMatch(entity -> entity == playerIn)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        car.setLocked(!car.isLocked(), true);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static void setCar(ItemStack stack, UUID carUUID) {
        stack.set(Main.CAR_UUID_DATA_COMPONENT, (Object)carUUID);
    }

    public static UUID getCar(ItemStack stack) {
        return (UUID)stack.get(Main.CAR_UUID_DATA_COMPONENT);
    }

    public static ItemStack getKeyForCar(UUID car) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.KEY.get());
        ItemKey.setCar(stack, car);
        return stack;
    }
}

