/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.gui.ContainerGasStation;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class GuiGasStation
extends ScreenBase<ContainerGasStation> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_gas_station.png");
    private TileEntityGasStation gasStation;
    private Inventory playerInventory;
    private static final int TITLE_COLOR = Color.WHITE.getRGB();
    private static final int FONT_COLOR = Color.DARK_GRAY.getRGB();
    protected Button buttonStart;
    protected Button buttonStop;

    public GuiGasStation(ContainerGasStation gasStation, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, gasStation, playerInventory, title);
        this.gasStation = gasStation.getGasStation();
        this.playerInventory = playerInventory;
        this.imageWidth = 176;
        this.imageHeight = 217;
    }

    protected void init() {
        super.init();
        this.buttonStart = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.start"), button -> {
            this.gasStation.setFueling(true);
            this.gasStation.sendStartFuelPacket(true);
        }).bounds(this.width / 2 - 20, this.topPos + 100, 40, 20).build());
        this.buttonStop = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.stop"), button -> {
            this.gasStation.setFueling(false);
            this.gasStation.sendStartFuelPacket(false);
        }).bounds(this.leftPos + this.imageWidth - 40 - 7, this.topPos + 100, 40, 20).build());
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.buttonStart.active = !this.gasStation.isFueling();
        this.buttonStop.active = this.gasStation.isFueling();
        guiGraphics.drawCenteredString(this.font, Component.translatable((String)"gui.gas_station").getString(), this.width / 2, this.topPos + 5, TITLE_COLOR);
        IFluidHandler fluidHandler = this.gasStation.getFluidHandlerInFront();
        if (fluidHandler instanceof Entity) {
            this.drawCarName(guiGraphics, (Entity)fluidHandler);
        }
        this.drawCarFuel(guiGraphics, fluidHandler);
        this.drawRefueled(guiGraphics);
        this.drawBuffer(guiGraphics);
        guiGraphics.drawString(this.font, this.playerInventory.getDisplayName().getVisualOrderText(), this.leftPos + 8, this.topPos + this.imageHeight - 93, FONT_COLOR, false);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        ItemStack stack = this.gasStation.getTradingInventory().getItem(0);
        if (stack.isEmpty()) {
            return;
        }
        if (mouseX >= this.leftPos + 18 && mouseX <= this.leftPos + 33 && mouseY >= this.topPos + 99 && mouseY <= this.topPos + 114) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"tooltip.trade", (Object[])new Object[]{stack.getCount(), stack.getHoverName(), this.gasStation.getTradeAmount()}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, list, mouseX - this.leftPos, mouseY - this.topPos);
        }
    }

    private void drawCarName(GuiGraphics guiGraphics, Entity entity) {
        String name = entity instanceof EntityGenericCar ? ((EntityGenericCar)entity).getShortName().getString() : entity.getDisplayName().getString();
        guiGraphics.drawString(this.font, Component.translatable((String)"gas_station.car_info", (Object[])new Object[]{Component.literal((String)name).withStyle(ChatFormatting.WHITE)}).getVisualOrderText(), this.leftPos + 63, this.topPos + 20, FONT_COLOR, false);
    }

    private void drawCarFuel(GuiGraphics guiGraphics, IFluidHandler handler) {
        if (handler == null) {
            guiGraphics.drawString(this.font, Component.translatable((String)"gas_station.no_car").getVisualOrderText(), this.leftPos + 63, this.topPos + 30, FONT_COLOR, false);
            return;
        }
        if (handler.getTanks() <= 0) {
            guiGraphics.drawString(this.font, Component.translatable((String)"gas_station.fuel_empty").getVisualOrderText(), this.leftPos + 63, this.topPos + 30, FONT_COLOR, false);
            return;
        }
        FluidStack tank = handler.getFluidInTank(0);
        MutableComponent fuelText = Component.translatable((String)"gas_station.car_fuel_amount", (Object[])new Object[]{Component.literal((String)String.valueOf(tank.getAmount())).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(handler.getTankCapacity(0))).withStyle(ChatFormatting.WHITE)});
        guiGraphics.drawString(this.font, fuelText.getVisualOrderText(), this.leftPos + 63, this.topPos + 30, FONT_COLOR, false);
        if (!tank.isEmpty()) {
            guiGraphics.drawString(this.font, Component.translatable((String)"gas_station.car_fuel_type", (Object[])new Object[]{Component.literal((String)tank.getHoverName().getString()).withStyle(ChatFormatting.WHITE)}).getVisualOrderText(), this.leftPos + 63, this.topPos + 40, FONT_COLOR, false);
        }
    }

    private void drawRefueled(GuiGraphics guiGraphics) {
        guiGraphics.drawString(this.font, Component.translatable((String)"gas_station.refueled", (Object[])new Object[]{Component.literal((String)String.valueOf(this.gasStation.getFuelCounter())).withStyle(ChatFormatting.WHITE)}).getVisualOrderText(), this.leftPos + 63, this.topPos + 60, FONT_COLOR, false);
    }

    private void drawBuffer(GuiGraphics guiGraphics) {
        FluidStack stack = this.gasStation.getStorage();
        if (stack.isEmpty()) {
            guiGraphics.drawString(this.font, Component.translatable((String)"gas_station.fuel_empty").getVisualOrderText(), this.leftPos + 63, this.topPos + 70, FONT_COLOR, false);
            return;
        }
        int amount = this.gasStation.getFuelAmount();
        MutableComponent amountText = Component.translatable((String)"gas_station.fuel_buffer_amount", (Object[])new Object[]{Component.literal((String)String.valueOf(amount)).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(this.gasStation.maxStorageAmount)).withStyle(ChatFormatting.WHITE)});
        guiGraphics.drawString(this.font, amountText.getVisualOrderText(), this.leftPos + 63, this.topPos + 70, FONT_COLOR, false);
        MutableComponent bufferText = Component.translatable((String)"gas_station.fuel_buffer_type", (Object[])new Object[]{Component.literal((String)stack.getHoverName().getString()).withStyle(ChatFormatting.WHITE)});
        guiGraphics.drawString(this.font, bufferText.getVisualOrderText(), this.leftPos + 63, this.topPos + 80, FONT_COLOR, false);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

