/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@OnlyIn(value=Dist.CLIENT)
public class PlayerEvents {
    private Minecraft minecraft = Minecraft.getInstance();
    private EntityVehicleBase lastVehicle = null;

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Pre evt) {
        if (!evt.getEntity().level().isClientSide()) {
            return;
        }
        if (!evt.getEntity().equals((Object)this.getPlayer())) {
            return;
        }
        EntityVehicleBase vehicle = this.getRidingVehicle();
        if (vehicle != null && this.lastVehicle == null) {
            if (vehicle.doesEnterThirdPerson()) {
                this.setThirdPerson(true);
            }
        } else if (vehicle == null && this.lastVehicle != null && this.lastVehicle.doesEnterThirdPerson()) {
            this.setThirdPerson(false);
        }
        this.lastVehicle = vehicle;
    }

    private void setThirdPerson(boolean third) {
        if (!((Boolean)Main.CLIENT_CONFIG.thirdPersonEnter.get()).booleanValue()) {
            return;
        }
        if (third) {
            this.minecraft.options.setCameraType(CameraType.THIRD_PERSON_BACK);
        } else {
            this.minecraft.options.setCameraType(CameraType.FIRST_PERSON);
        }
    }

    private LocalPlayer getPlayer() {
        return this.minecraft.player;
    }

    private Entity getRidingEntity() {
        return this.getPlayer().getVehicle();
    }

    private EntityVehicleBase getRidingVehicle() {
        Entity e = this.getRidingEntity();
        if (e instanceof EntityVehicleBase) {
            return (EntityVehicleBase)e;
        }
        return null;
    }
}

