/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntitySign
extends TileEntityBase {
    private String[] text = new String[8];

    public TileEntitySign(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.SIGN_TILE_ENTITY_TYPE.get(), pos, state);
        Arrays.fill(this.text, "");
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        for (int i = 0; i < this.text.length; ++i) {
            compound.putString("text" + i, this.text[i]);
        }
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = compound.getString("text" + i);
        }
        super.loadAdditional(compound, provider);
    }

    public String getText(int i) {
        if (i < 0 || i >= this.text.length) {
            return "";
        }
        return this.text[i];
    }

    public String[] getSignText() {
        return this.text;
    }

    public void setText(int i, String s) {
        if (i < 0 || i >= this.text.length || s == null) {
            return;
        }
        this.text[i] = s;
        this.setChanged();
        this.synchronize();
    }

    public void setText(String[] s) {
        if (s == null || s.length != this.text.length) {
            return;
        }
        this.text = s;
        this.setChanged();
        this.synchronize();
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.sign");
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }
}

