/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.BlockCarWorkshop;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.corelib.block.IItemBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockCarWorkshopOutter
extends BlockBase
implements IItemBlock {
    public static final IntegerProperty POSITION = IntegerProperty.create((String)"position", (int)0, (int)8);

    public BlockCarWorkshopOutter() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).strength(3.0f).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POSITION, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public Item toItem() {
        return new BlockItem((Block)this, new Item.Properties());
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockPos tePos = BlockCarWorkshopOutter.findCenter(level, blockPos);
        if (tePos == null) {
            return InteractionResult.FAIL;
        }
        return ((BlockCarWorkshop)ModBlocks.CAR_WORKSHOP.get()).useWithoutItem(level.getBlockState(tePos), level, tePos, player, blockHitResult);
    }

    @Override
    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        this.validate(worldIn, pos);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, worldIn, pos, newState, isMoving);
        this.validate(worldIn, pos);
    }

    private void validate(Level worldIn, BlockPos pos) {
        BlockPos tePos = BlockCarWorkshopOutter.findCenter(worldIn, pos);
        if (tePos == null) {
            return;
        }
        BlockEntity te = worldIn.getBlockEntity(tePos);
        if (!(te instanceof TileEntityCarWorkshop)) {
            return;
        }
        TileEntityCarWorkshop workshop = (TileEntityCarWorkshop)te;
        workshop.checkValidity();
    }

    private static BlockPos findCenter(Level world, BlockPos pos) {
        if (BlockCarWorkshopOutter.isCenter(world, pos.offset(0, 0, 1))) {
            return pos.offset(0, 0, 1);
        }
        if (BlockCarWorkshopOutter.isCenter(world, pos.offset(1, 0, 0))) {
            return pos.offset(1, 0, 0);
        }
        if (BlockCarWorkshopOutter.isCenter(world, pos.offset(1, 0, 1))) {
            return pos.offset(1, 0, 1);
        }
        if (BlockCarWorkshopOutter.isCenter(world, pos.offset(0, 0, -1))) {
            return pos.offset(0, 0, -1);
        }
        if (BlockCarWorkshopOutter.isCenter(world, pos.offset(-1, 0, 0))) {
            return pos.offset(-1, 0, 0);
        }
        if (BlockCarWorkshopOutter.isCenter(world, pos.offset(-1, 0, -1))) {
            return pos.offset(-1, 0, -1);
        }
        if (BlockCarWorkshopOutter.isCenter(world, pos.offset(-1, 0, 1))) {
            return pos.offset(-1, 0, 1);
        }
        if (BlockCarWorkshopOutter.isCenter(world, pos.offset(1, 0, -1))) {
            return pos.offset(1, 0, -1);
        }
        return null;
    }

    private static boolean isCenter(Level world, BlockPos pos) {
        return world.getBlockState(pos).getBlock().equals(ModBlocks.CAR_WORKSHOP.get());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POSITION, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POSITION});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

