/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import java.awt.Color;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.waypointmanager.group.DeleteConfirmGroupPopup;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class EditGroupPopup
extends PopupButtonScreen<WaypointGroup> {
    private final LinearLayout layout = LinearLayout.vertical();
    private TextBox textBox;
    protected static Integer defaultGroupColor = new Color(20, 20, 20).getRGB();
    private final WaypointGroup group;
    private boolean closeOnDelete = false;
    private Integer color;
    private Boolean colorOverride;
    private boolean isNew = false;
    private boolean enabled = true;

    public EditGroupPopup(Component title, WaypointGroup group) {
        super(title);
        this.group = group;
        this.colorOverride = group.colorOverride();
    }

    public EditGroupPopup(Component title) {
        this(title, WaypointFactoryImpl.instance.createWaypointGroup(""));
        this.isNew = true;
    }

    protected void init() {
        this.textBox = new TextBox(this.group.getName(), this.font, 120, 20);
        CheckBox colorOverride = new CheckBox(Constants.getString("jm.waypoint.edit_group.color_override"), this.group.colorOverride(), this::setColorOverride);
        colorOverride.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.edit_group.color_override.tooltip")));
        this.layout.spacing(12).defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new MultiLineTextWidget((Component)this.title.copy().withStyle(ChatFormatting.BOLD), this.font).setMaxWidth(150).setCentered(true));
        if (this.group.isLocked() || WaypointGroupStore.DEFAULT.getGuid().equals(this.group.getGuid())) {
            this.textBox.setEditable(false);
            MultiLineTextWidget locked = (MultiLineTextWidget)this.layout.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.translatable((String)"jm.waypoint.edit_group.locked").copy().withStyle(ChatFormatting.RED), this.font).setMaxWidth(150).setCentered(true));
            locked.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.edit_group.locked.tooltip")));
        } else {
            this.setInitialFocus((GuiEventListener)this.textBox);
        }
        this.layout.addChild((LayoutElement)this.enabledCheckbox());
        LinearLayout colors = LinearLayout.horizontal();
        colors.spacing(6);
        Integer initGroupColor = this.group.getColor() == null ? defaultGroupColor : this.group.getColor();
        colors.addChild((LayoutElement)new ColorPickerButton(20, 20, () -> initGroupColor, this::setColor));
        colors.addChild((LayoutElement)colorOverride, LayoutSettings::alignVerticallyMiddle);
        LinearLayout bottomButtons = LinearLayout.horizontal();
        bottomButtons.spacing(6);
        PopupButton deleteButton = (PopupButton)bottomButtons.addChild(new PopupButton<Tuple2>(this.font.width(Constants.getString("jm.common.delete")) + 10, 0, Constants.getString("jm.common.delete"), () -> new DeleteConfirmGroupPopup(this.group), this::deleteGroup));
        deleteButton.setEnabled(!this.group.getGuid().equals(WaypointGroupStore.DEFAULT.getGuid()) && !this.group.isLocked() && !this.isNew);
        bottomButtons.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.waypoint.save"), b -> this.save()).width(this.font.width((FormattedText)CommonComponents.GUI_CONTINUE) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> super.onClose()).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        this.layout.addChild((LayoutElement)((TextBox)LinearLayout.horizontal().addChild((LayoutElement)this.textBox)));
        this.layout.addChild((LayoutElement)colors);
        this.layout.addChild((LayoutElement)bottomButtons);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void deleteGroup(Tuple2<Boolean, Boolean> tuple) {
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.DELETED, ((Boolean)tuple.a()).booleanValue()));
        this.closeOnDelete = true;
        super.onClose();
    }

    private void setColorOverride(Button button) {
        this.colorOverride = ((CheckBox)button).getToggled();
    }

    private void setColor(ColorPickerScreen.ColorPickerResponse colorPickerResponse) {
        if (!colorPickerResponse.canceled()) {
            this.color = colorPickerResponse.color();
        }
    }

    protected void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        if (this.minecraft.screen == this && this.closeOnDelete) {
            this.onClose();
        }
    }

    public void renderPopupScreenBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blitSprite(BACKGROUND_SPRITE, this.layout.getX() - 18, this.layout.getY() - 18, this.layout.getWidth() + 36, this.layout.getHeight() + 36);
    }

    private CheckBox enabledCheckbox() {
        boolean enabled = this.group == null || this.group.isEnabled();
        return new CheckBox(Constants.getString("jm.common.enabled"), enabled, button -> this.setEnabled(((CheckBox)button).getToggled()));
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.save();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void save() {
        String name = this.textBox.getValue();
        if (!name.isEmpty()) {
            this.group.setName(name);
            this.group.setEnabled(this.enabled);
            if (this.colorOverride != null) {
                this.group.setColorOverride(this.colorOverride.booleanValue());
                if (this.color != null && this.colorOverride.booleanValue()) {
                    this.group.setColor(this.color);
                }
            }
            this.setResponseAndClose(this.group);
        }
    }

    @Override
    protected void onClosed() {
        if (this.onClose != null) {
            super.onClosed();
        } else {
            EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.UPDATE));
        }
        super.onClose();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }
}

