/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.dispatchers;

import java.awt.geom.Point2D;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.event.FullscreenMapEvent;
import journeymap.api.v2.client.fullscreen.IBlockInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class FullscreenEventDispatcher {
    public static boolean clickEventPre(BlockPos location, ResourceKey<Level> level, Point2D.Double mousePosition, int button) {
        FullscreenMapEvent.ClickEvent preClickEvent = new FullscreenMapEvent.ClickEvent(FullscreenMapEvent.Stage.PRE, location, level, mousePosition, button);
        EventBus.post(preClickEvent);
        return preClickEvent.isCancelled();
    }

    public static void clickEventPost(BlockPos location, ResourceKey<Level> level, Point2D.Double mousePosition, int button) {
        FullscreenMapEvent.ClickEvent postClickEvent = new FullscreenMapEvent.ClickEvent(FullscreenMapEvent.Stage.POST, location, level, mousePosition, button);
        EventBus.post(postClickEvent);
    }

    public static boolean dragEventPre(BlockPos location, ResourceKey<Level> level, Point2D.Double mousePosition, int button) {
        FullscreenMapEvent.MouseDraggedEvent draggedEvent = new FullscreenMapEvent.MouseDraggedEvent(FullscreenMapEvent.Stage.PRE, location, level, mousePosition, button);
        EventBus.post(draggedEvent);
        return draggedEvent.isCancelled();
    }

    public static void dragEventPost(BlockPos location, ResourceKey<Level> level, Point2D.Double mousePosition, int button) {
        FullscreenMapEvent.MouseDraggedEvent draggedEvent = new FullscreenMapEvent.MouseDraggedEvent(FullscreenMapEvent.Stage.POST, location, level, mousePosition, button);
        EventBus.post(draggedEvent);
    }

    public static void moveEvent(ResourceKey<Level> level, IBlockInfo info, Point2D.Double mousePosition) {
        FullscreenMapEvent.MouseMoveEvent mouseMoveEvent = new FullscreenMapEvent.MouseMoveEvent(level, info, mousePosition);
        EventBus.post(mouseMoveEvent);
    }
}

