/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.gui;

import de.maxhenkel.plane.corelib.inventory.ScreenBase;
import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class PlaneScreen
extends ScreenBase<ContainerPlane> {
    private static final ResourceLocation CAR_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"textures/gui/gui_plane.png");
    private static final Component TEXT_FUEL = Component.translatable((String)"gui.plane.fuel");
    private static final Component TEXT_DAMAGE = Component.translatable((String)"gui.plane.damage");
    private static final Component TEXT_ENGINE = Component.translatable((String)"gui.plane.throttle");
    private Inventory playerInv;
    private EntityPlaneSoundBase plane;

    public PlaneScreen(ContainerPlane containerCar, Inventory playerInv, Component title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.plane = containerCar.getPlane();
        this.imageWidth = 176;
        this.imageHeight = 222;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.plane.getName().getVisualOrderText(), 7, 61, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName().getVisualOrderText(), 8, this.imageHeight - 96 + 2, 0x404040, false);
        guiGraphics.drawString(this.font, TEXT_FUEL.getVisualOrderText(), 7, 9, 0x404040, false);
        guiGraphics.drawString(this.font, TEXT_DAMAGE.getVisualOrderText(), 95, 9, 0x404040, false);
        guiGraphics.drawString(this.font, TEXT_ENGINE.getVisualOrderText(), 7, 35, 0x404040, false);
        if (mouseX >= this.leftPos + 8 && mouseX < this.leftPos + 80 && mouseY >= this.topPos + 20 && mouseY < this.topPos + 30) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"tooltip.plane.fuel", (Object[])new Object[]{String.valueOf(this.plane.getFuel())}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, list, mouseX - this.leftPos, mouseY - this.topPos);
        }
        if (mouseX >= this.leftPos + 96 && mouseX < this.leftPos + 168 && mouseY >= this.topPos + 20 && mouseY < this.topPos + 30) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.plane.damage", (Object[])new Object[]{String.valueOf(MathUtils.round(this.plane.getPlaneDamage(), 2))}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, list, mouseX - this.leftPos, mouseY - this.topPos);
        }
        if (mouseX >= this.leftPos + 8 && mouseX < this.leftPos + 80 && mouseY >= this.topPos + 46 && mouseY < this.topPos + 56) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.plane.throttle", (Object[])new Object[]{String.valueOf(Math.round(this.plane.getEngineSpeed() * 100.0f))}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, list, mouseX - this.leftPos, mouseY - this.topPos);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawFuel(guiGraphics, (float)this.plane.getFuel() / (float)this.plane.getMaxFuel());
        this.drawDamage(guiGraphics, (100.0f - Math.min(this.plane.getPlaneDamage(), 100.0f)) / 100.0f);
        this.drawThrottle(guiGraphics, this.plane.getEngineSpeed());
    }

    public void drawFuel(GuiGraphics guiGraphics, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(this.texture, i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawThrottle(GuiGraphics guiGraphics, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(this.texture, i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawDamage(GuiGraphics guiGraphics, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(this.texture, i + 96, j + 20, 176, 20, scaled, 10);
    }
}

