/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane;

import de.maxhenkel.plane.ClientConfig;
import de.maxhenkel.plane.ServerConfig;
import de.maxhenkel.plane.corelib.CommonRegistry;
import de.maxhenkel.plane.entity.EntityBushPlane;
import de.maxhenkel.plane.entity.EntityCargoPlane;
import de.maxhenkel.plane.entity.EntityPlane;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.entity.EntityVehicleBase;
import de.maxhenkel.plane.entity.render.BushPlaneModel;
import de.maxhenkel.plane.entity.render.CargoPlaneModel;
import de.maxhenkel.plane.entity.render.PlaneModel;
import de.maxhenkel.plane.events.CreativeTabEvents;
import de.maxhenkel.plane.events.InteractEvents;
import de.maxhenkel.plane.events.KeyEvents;
import de.maxhenkel.plane.events.RenderEvents;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.gui.PlaneScreen;
import de.maxhenkel.plane.item.ModItems;
import de.maxhenkel.plane.loottable.CopyPlaneData;
import de.maxhenkel.plane.net.MessageControlPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import de.maxhenkel.plane.sound.ModSounds;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="plane")
public class Main {
    public static final String MODID = "plane";
    private static final DeferredRegister<LootItemFunctionType<?>> LOOT_FUNCTION_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (String)"plane");
    public static final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<CopyPlaneData>> COPY_PLANE_DATA = LOOT_FUNCTION_TYPE_REGISTER.register("copy_plane_data", () -> new LootItemFunctionType(CopyPlaneData.CODEC));
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    public static KeyMapping PLANE_KEY;
    public static KeyMapping FORWARD_KEY;
    public static KeyMapping BACK_KEY;
    public static KeyMapping LEFT_KEY;
    public static KeyMapping RIGHT_KEY;
    public static KeyMapping UP_KEY;
    public static KeyMapping DOWN_KEY;
    public static KeyMapping START_KEY;
    public static KeyMapping BRAKE_KEY;
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER;
    public static final DeferredHolder<EntityType<?>, EntityType<EntityPlane>> PLANE_ENTITY_TYPE;
    public static final DeferredHolder<EntityType<?>, EntityType<EntityCargoPlane>> CARGO_PLANE_ENTITY_TYPE;
    public static final DeferredHolder<EntityType<?>, EntityType<EntityBushPlane>> BUSH_PLANE_ENTITY_TYPE;
    private static final DeferredRegister<MenuType<?>> MENU_TYPE_REGISTER;
    public static DeferredHolder<MenuType<?>, MenuType<ContainerPlane>> PLANE_CONTAINER_TYPE;

    public Main(IEventBus eventBus) {
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::onRegisterPayloadHandler);
        eventBus.addListener(CreativeTabEvents::onCreativeModeTabBuildContents);
        eventBus.addListener(this::onRegisterCapabilities);
        SERVER_CONFIG = CommonRegistry.registerConfig(MODID, ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(MODID, ModConfig.Type.CLIENT, ClientConfig.class);
        if (FMLEnvironment.dist.isClient()) {
            eventBus.addListener(this::clientSetup);
            eventBus.addListener(this::onRegisterKeyBinds);
            eventBus.addListener(this::onRegisterScreens);
        }
        ModItems.init(eventBus);
        ModSounds.init(eventBus);
        ENTITY_REGISTER.register(eventBus);
        MENU_TYPE_REGISTER.register(eventBus);
        LOOT_FUNCTION_TYPE_REGISTER.register(eventBus);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new InteractEvents());
    }

    public void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("0");
        CommonRegistry.registerMessage(registrar, MessageControlPlane.class);
        CommonRegistry.registerMessage(registrar, MessagePlaneGui.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new KeyEvents());
        NeoForge.EVENT_BUS.register((Object)new RenderEvents());
        EntityRenderers.register((EntityType)((EntityType)PLANE_ENTITY_TYPE.get()), manager -> new PlaneModel(manager));
        EntityRenderers.register((EntityType)((EntityType)CARGO_PLANE_ENTITY_TYPE.get()), manager -> new CargoPlaneModel(manager));
        EntityRenderers.register((EntityType)((EntityType)BUSH_PLANE_ENTITY_TYPE.get()), manager -> new BushPlaneModel(manager));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRegisterScreens(RegisterMenuScreensEvent containers) {
        MenuScreens.ScreenConstructor factory = (container, playerInventory, name) -> new PlaneScreen((ContainerPlane)container, playerInventory, name);
        containers.register((MenuType)PLANE_CONTAINER_TYPE.get(), factory);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        PLANE_KEY = new KeyMapping("key.plane", 80, "category.plane");
        FORWARD_KEY = new KeyMapping("key.plane_add_thrust", 73, "category.plane");
        BACK_KEY = new KeyMapping("key.plane_remove_thrust", 75, "category.plane");
        LEFT_KEY = new KeyMapping("key.plane_left", 65, "category.plane");
        RIGHT_KEY = new KeyMapping("key.plane_right", 68, "category.plane");
        UP_KEY = new KeyMapping("key.plane_up", 83, "category.plane");
        DOWN_KEY = new KeyMapping("key.plane_down", 87, "category.plane");
        START_KEY = new KeyMapping("key.plane_start", 82, "category.plane");
        BRAKE_KEY = new KeyMapping("key.plane_brake", 66, "category.plane");
        event.register(PLANE_KEY);
        event.register(FORWARD_KEY);
        event.register(BACK_KEY);
        event.register(LEFT_KEY);
        event.register(RIGHT_KEY);
        event.register(UP_KEY);
        event.register(DOWN_KEY);
        event.register(START_KEY);
        event.register(BRAKE_KEY);
    }

    @Nullable
    public static EntityPlaneSoundBase getPlaneByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.level().getEntitiesOfClass(EntityPlaneSoundBase.class, new AABB(player.getX() - distance, player.getY() - distance, player.getZ() - distance, player.getX() + distance, player.getY() + distance, player.getZ() + distance), entity -> entity.getUUID().equals(uuid)).stream().findAny().orElse(null);
    }

    public void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        this.registerEntityCapabilities(event, PLANE_ENTITY_TYPE);
        this.registerEntityCapabilities(event, BUSH_PLANE_ENTITY_TYPE);
        this.registerEntityCapabilities(event, CARGO_PLANE_ENTITY_TYPE);
    }

    private <T extends EntityVehicleBase> void registerEntityCapabilities(RegisterCapabilitiesEvent event, DeferredHolder<EntityType<?>, EntityType<T>> holder) {
        event.registerEntity(Capabilities.FluidHandler.ENTITY, (EntityType)holder.get(), (object, context) -> {
            if (object instanceof IFluidHandler) {
                IFluidHandler fluidHandler = (IFluidHandler)object;
                return fluidHandler;
            }
            return null;
        });
        event.registerEntity(Capabilities.EnergyStorage.ENTITY, (EntityType)holder.get(), (object, context) -> {
            if (object instanceof IEnergyStorage) {
                IEnergyStorage energyStorage = (IEnergyStorage)object;
                return energyStorage;
            }
            return null;
        });
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)holder.get(), (object, context) -> {
            if (object instanceof IItemHandler) {
                IItemHandler itemHandler = (IItemHandler)object;
                return itemHandler;
            }
            return null;
        });
    }

    static {
        ENTITY_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)MODID);
        PLANE_ENTITY_TYPE = ENTITY_REGISTER.register(MODID, () -> CommonRegistry.registerEntity(MODID, MODID, MobCategory.MISC, EntityPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).sized(3.5f, 2.0f)));
        CARGO_PLANE_ENTITY_TYPE = ENTITY_REGISTER.register("cargo_plane", () -> CommonRegistry.registerEntity(MODID, "cargo_plane", MobCategory.MISC, EntityCargoPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).sized(3.5f, 2.0f)));
        BUSH_PLANE_ENTITY_TYPE = ENTITY_REGISTER.register("bush_plane", () -> CommonRegistry.registerEntity(MODID, "bush_plane", MobCategory.MISC, EntityBushPlane.class, builder -> builder.setTrackingRange(256).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).sized(3.5f, 2.0f)));
        MENU_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)MODID);
        PLANE_CONTAINER_TYPE = MENU_TYPE_REGISTER.register(MODID, () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)(windowId, inv, data) -> {
            EntityPlaneSoundBase plane = Main.getPlaneByUUID(inv.player, data.readUUID());
            if (plane == null) {
                return null;
            }
            return new ContainerPlane(windowId, plane, inv);
        }), FeatureFlags.VANILLA_SET));
    }
}

