/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane;

import de.maxhenkel.plane.corelib.config.ConfigBase;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig
extends ConfigBase {
    public final ModConfigSpec.BooleanValue showPlaneInfo;
    public final ModConfigSpec.DoubleValue planeInfoScale;
    public final ModConfigSpec.EnumValue<SpeedType> planeInfoSpeedType;
    public final ModConfigSpec.DoubleValue planeZoom;

    public ClientConfig(ModConfigSpec.Builder builder) {
        super(builder);
        this.showPlaneInfo = builder.define("plane_info.enabled", true);
        this.planeInfoScale = builder.defineInRange("plane_info.scale", 0.75, 0.1, 2.0);
        this.planeInfoSpeedType = builder.defineEnum("plane_info.speed_type", (Enum)SpeedType.KILOMETERS_PER_HOUR);
        this.planeZoom = builder.defineInRange("plane.third_person_zoom", 6.0, 1.0, 20.0);
    }

    public static enum SpeedType {
        KILOMETERS_PER_HOUR("plane.speedtype.kmh", bpt -> bpt * 20.0 * 60.0 * 60.0 / 1000.0),
        BLOCKS_PER_SECOND("plane.speedtype.bps", bpt -> bpt * 20.0);

        private String translationKey;
        private Function<Double, Double> converterFunction;

        private SpeedType(String translationKey, Function<Double, Double> converterFunction) {
            this.translationKey = translationKey;
            this.converterFunction = converterFunction;
        }

        public Component getTextComponent(double bpt) {
            return Component.translatable((String)this.translationKey, (Object[])new Object[]{Math.round(this.converterFunction.apply(bpt))});
        }
    }
}

